new const NINTENDOMOD_DONKEYKONG_PLUGIN[] = "Nintendo Mod X Donkey Kong"
new const NINTENDOMOD_DONKEYKONG_VERSION[] = "2.1"
new const NINTENDOMOD_DONKEYKONG_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: Thickened Skin
		* As level increases, health increases.
	2nd Passive: Sharp-Sightedness
		* As level increases, damage increases.
	Skill 1: Banana Nades
		* Increase hegrenade damage.
	Skill 2: Chest Beat
		* Scares enemies, when enemy attacks Donkey Kong, he moves randomly in different directions.
	Skill 3: Knockback
		* Chance on attack to push the target backwards a few feet.
	PowerUp: Stomp
		* Stuns enemy for some seconds and feels invincible for a short time.


	Based on Soloist's original source code Donkey Kong v1.0, updated by Mephisto
	Version 2.1
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.1
			* PowerUp times adjusted to other chars
		Version 2.0.1
			* plugin title changed
		Version 2.0
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <fakemeta>
#include <nintendomod>

new charName[] = "DonkeyKong";
new passiveName[] = "Thickened Skin";
new passive2Name[] = "Sharp-Sightedness";
new skill1Name[] = "Banana Nades";
new skill2Name[] = "Chest Beat";
new skill3Name[] = "Knockback";
new powerupName[] = "Stomp";
new initName[] = "DonkeyKong_Init";
new keyDownName[] = "DonkeyKong_Stomp";

new passiveHelp[] = "As level increases, health increases.";
new passive2Help[] = "As level increases, damage increases.";
new skill1Help[] = "Increase hegrenade damage.";
new skill2Help[] = "Scares enemies, when enemy attacks Donkey Kong, he moves randomly in different directions.";
new skill3Help[] = "Chance on attack to push the target backwards a few feet.";
new powerupHelp[] = "Stuns enemy for some seconds and feels invincible for a short time.";

new const Float:DONKEYKONG_THICKENEDSKINHEALTH[11] = {105.0, 110.0, 120.0, 130.0, 140.0, 150.0, 160.0, 170.0, 180.0, 190.0, 200.0};
new const Float:DONKEYKONG_SHARPEYE[5] = {0.06, 0.07, 0.08, 0.09, 0.10};
new const Float:DONKEYKONG_POWERUPGM[3] = {2.0, 2.75, 3.5};
new const Float:DONKEYKONG_STUNTIME[3] = {4.0, 5.0, 6.0};
new const Float:DONKEYKONG_STOMPRADIUS[3] = {500.0, 525.0, 550.0};
new const DONKEYKONG_BANANANADESDMG[4] = {25, 50, 75, 80};
new const Float:DONKEYKONG_CHESTBEATPROB[4] = {0.333, 0.666, 0.75, 0.78};
new const Float:DONKEYKONG_KNOCKBACKPROB[4] = {0.333, 0.666, 0.75, 0.78};

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new bool:Stomped[33];

new DonkeyNadeTrial, Stomp;

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_DONKEYKONG_PLUGIN, NINTENDOMOD_DONKEYKONG_VERSION, NINTENDOMOD_DONKEYKONG_AUTHOR);
	register_cvar("NintendoMod_DonkeyKong_Version", NINTENDOMOD_DONKEYKONG_VERSION, FCVAR_SERVER|FCVAR_SPONLY);
	set_cvar_string("NintendoMod_DonkeyKong_Version", NINTENDOMOD_DONKEYKONG_VERSION);

	register_event("ResetHUD", "ResetHUD", "b");

	register_event("Damage", "DonkeyKong_Damage", "b", "2!0");
	register_forward(FM_Touch, "DonkeyKong_Climbing");
	register_event("AmmoX", "DonkeyKong_DrawGrenade", "b");
	register_event("CurWeapon", "DonkeyKong_StompWeapon","be","1=1");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	DonkeyNadeTrial = engfunc(EngFunc_PrecacheModel, "sprites/zbeam5.spr");
	Stomp = precache_model("sprites/white.spr");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	remove_task(id);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public DonkeyKong_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value;
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	Stomped[id] = false;

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	DonkeyKong_Passive(id);

	return PLUGIN_CONTINUE;
}

public DonkeyKong_Passive(id) // Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	if(PlayerLevel[id] > 10)
		Nintendo_SetHealth(id, DONKEYKONG_THICKENEDSKINHEALTH[10], true);
	else
		Nintendo_SetHealth(id, DONKEYKONG_THICKENEDSKINHEALTH[PlayerLevel[id]], true);

	return PLUGIN_CONTINUE;
}

public DonkeyKong_Damage(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	new damage = read_data(2);
	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart);
	new headshot = bodypart == 1 ? 1 : 0;

	if(!Nintendo_IsValidPlayer(attacker, true))
		return PLUGIN_HANDLED;

	if(weapon == 4 && Nintendo_HasChar(attacker, charName))
		DonkeyKong_BananaNades(id, attacker, damage, headshot);

	if(PlayerLevel[attacker] > 10 && Nintendo_HasChar(attacker, charName) && id != attacker && Nintendo_TeamKill(id, attacker))
		Nintendo_ExtraDamage(attacker, id, floatround(damage * DONKEYKONG_SHARPEYE[PlayerLevel[attacker] - 11]), "Sharp-Sightedness", headshot);

	if(Nintendo_HasChar(id, charName))
		DonkeyKong_ChestBeat(id, attacker);
	else
		DonkeyKong_Knockback(id, attacker)

	return PLUGIN_CONTINUE;
}

public DonkeyKong_BananaNades(victim, attacker, damage, headshot) // Skill 1
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(victim, true))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[attacker] > 0)
	{
		if(Nintendo_TeamKill(victim, attacker))
			Nintendo_ExtraDamage(attacker, victim, DONKEYKONG_BANANANADESDMG[PlayerSkill1[attacker] - 1], "Banana Nades", headshot);
	}

	return PLUGIN_CONTINUE;
}

public DonkeyKong_DrawGrenade(id) // Skill 1
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[id] > 0)
	{
		new iCurrent = -1;
		while((iCurrent = engfunc(EngFunc_FindEntityByString, iCurrent, "classname", "grenade")) > 0)
		{
			new string[32]

			pev(iCurrent, pev_model, string, 31);

			if(id == pev(iCurrent, pev_owner) && equali("models/w_hegrenade.mdl", string))
			{
				Nintendo_SetGlow(iCurrent, kRenderFxGlowShell, 255, 255, 0, kRenderTransAlpha, 25);

				message_begin(MSG_BROADCAST ,SVC_TEMPENTITY)
				write_byte(22)
				write_short(iCurrent)
				write_short(DonkeyNadeTrial)
				write_byte(10)
				write_byte(10)
				write_byte(225)
				write_byte(255)
				write_byte(0)
				write_byte(255)
				message_end()
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public DonkeyKong_ChestBeat(victim, attacker)// Skill 2
{
	if(!Nintendo_Active() || !Nintendo_HasChar(victim, charName) || !Nintendo_IsValidPlayer(victim) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(PlayerSkill2[victim] > 0 && victim !=  attacker)
	{
		if(Nintendo_TeamKill(victim, attacker))
		{
			new Float:randomnumber = random_float(0.0,1.0);
			if(randomnumber <= DONKEYKONG_CHESTBEATPROB[PlayerSkill2[victim] - 1])
			{
				new Float:velocity[3];
				pev(attacker, pev_velocity, velocity);
				switch(random_num(0, 3))
				{
					case 0: velocity[0] += 200.0;
					case 1: velocity[0] -= 200.0;
					case 2: velocity[1] += 200.0;
					case 3: velocity[1] -= 200.0;
				}
				set_pev(attacker, pev_velocity, {0.0, 0.0, 0.0});
				set_pev(attacker, pev_velocity, velocity);
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public DonkeyKong_Knockback(victim, attacker) // Skill 3
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(victim) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(PlayerSkill3[attacker] > 0)
	{
		if(Nintendo_TeamKill(victim, attacker))
		{
			new Float:randomnumber = random_float(0.0,1.0);
			if(randomnumber <= DONKEYKONG_KNOCKBACKPROB[PlayerSkill3[attacker] - 1])
			{
				new origin[3], vorigin[3];

				get_user_origin(attacker, origin);
				get_user_origin(victim, vorigin);

				new Float:velocity[3];
				velocity[0] = (vorigin[0] - origin[0]) * 1.0;
				velocity[1] = (vorigin[1] - origin[1]) * 1.0;
				velocity[2] = 50.0;
				set_pev(attacker, pev_velocity, {0.0, 0.0, 0.0});
				set_pev(victim, pev_velocity, velocity);
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public DonkeyKong_Stomp()
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		if(!(pev(id, pev_flags) &FL_ONGROUND))
		{
			Nintendo_PowerUpUsed(id, 1, 30);

			new Float:velocity[3], idOrigin[3], vicOrigin[3];

			set_pev(id, pev_takedamage, 0.0);

			velocity[0] = 0.0;
			velocity[1] = 0.0;
			velocity[2] = -600.0;
			set_pev(id, pev_velocity, velocity);
			set_task(DONKEYKONG_POWERUPGM[PlayerPowerUp[id] - 1], "DonkeyKong_RemoveGod", id);

			get_user_origin(id, idOrigin);

			message_begin(MSG_ONE, SVC_TEMPENTITY, idOrigin, id);
			write_byte(TE_BEAMCYLINDER);
			write_coord(idOrigin[0]);
			write_coord(idOrigin[1]);
			write_coord(idOrigin[2]-16);
			write_coord(idOrigin[0]);
			write_coord(idOrigin[1]);
			write_coord(idOrigin[2] + 500);
			write_short(Stomp);
			write_byte(0); // startframe
			write_byte(1); // framerate
			write_byte(6); // 3 life 2
			write_byte(8); // width 16
			write_byte(1); // noise
			write_byte(100); // r
			write_byte(100); // g
			write_byte(255); // b
			write_byte(192); //brightness
			write_byte(0); // speed
			message_end();

			new players[32], num, player;
			get_players(players, num);

			for(new i = 0; i <= num; i++)
			{
				player = players[i];
				if(Nintendo_IsValidPlayer(player))
				{
					if(Nintendo_TeamKill(id, player))
					{
						get_user_origin(player, vicOrigin);

						if(get_distance(vicOrigin, idOrigin) < DONKEYKONG_STOMPRADIUS[PlayerPowerUp[id] - 1])
						{
							new speed, parm[2], Float:velocity[3];

							speed = pev(player, pev_maxspeed);

							parm[0] = player;
							parm[1] = speed;

							velocity[0] = 0.0;
							velocity[1] = 0.0;
							velocity[2] = 100.0;

							set_pev(player, pev_velocity, velocity);
							Nintendo_SetSpeed(player, 1.0);

							Stomped[player] = true;

							message_begin(MSG_ONE, get_user_msgid("ScreenShake"), {0,0,0}, id)
							write_short(1<<14)
							write_short(1<<14)
							write_short(1<<14)
							message_end()

							set_task(DONKEYKONG_STUNTIME[PlayerPowerUp[id] - 1], "DonkeyKong_ResetSpeed", 0, parm, 2);
						}
					}
				}
			}
		}
		else
			Nintendo_PowerUpDeny(id, "You must be in the air.");
	}

	return PLUGIN_CONTINUE;
}

public DonkeyKong_StompWeapon(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(Stomped[id])
	{
		new Float:velocity[3];
		velocity[0] = 0.0;
		velocity[1] = 0.0;
		velocity[2] = 10.0;

		set_pev(id, pev_velocity, velocity);
		Nintendo_SetSpeed(id, 1.0);
	}

	return PLUGIN_CONTINUE;
}

public DonkeyKong_RemoveGod(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	set_pev(id, pev_takedamage, 2.0);

	return PLUGIN_CONTINUE;
}

public DonkeyKong_ResetSpeed(parm[])
{
	new id = parm[0];

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new Float:speed = float(parm[1]);

	Nintendo_SetSpeed(id, speed);
	Stomped[id] = false;

	return PLUGIN_CONTINUE;
}
